using System;
using System.Collections;
using Method = System.Reflection.MethodBase;
using System.Drawing.Printing;
using System.Data;
using System.Text;
using Microsoft.Reporting.WinForms;
using System.Reflection;
using System.IO;
using TABLE = gov.va.med.vbecs.Common.VbecsTables;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;

namespace gov.va.med.vbecs.BOL
{
	#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///<Developer>Margaret Jablonski</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>8/24/2004</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>Summary description for TransfusionRequirementsReport.</summary>

	#endregion

	public class TransfusionRequirementsReport:VbecsReport
	{
		#region Variables

		private bool _isCumulativeReport = true;
        private DataTable _dtReportData = new DataTable();

		#endregion
		
		#region Consructors

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/25/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5470"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>Initialized TransfusionComplications object</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5471"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// TransfusionRequirementsReport
		/// </summary>
		public TransfusionRequirementsReport()
		{
		}

		#endregion

		#region Properties

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/25/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5474"> 
		///		<ExpectedInput>Valid TransfusionRequirementsReport object</ExpectedInput>
		///		<ExpectedOutput>IsCumulativeReport property</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5475"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets or sets the report type (cumulative or partial) - used in UC 89
		/// </summary>
		public bool IsCumulativeReport
		{
			get
			{
				return this._isCumulativeReport;
			}
			set
			{
				this._isCumulativeReport = value;
				//CR 3187
				this.ParameterRow[ARTIFICIAL.IsCumulativeReport] = value;
			}
		}
		#endregion


		#region Methods

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/25/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5472"> 
		///		<ExpectedInput>Valid Transfusion Requiremets Report object</ExpectedInput>
		///		<ExpectedOutput>DataTable containing Transfusion Requirements report data</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5473"> 
		///		<ExpectedInput>Invalid division code </ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Generate data source for Transfusion Requiremets Report
		/// </summary>
		/// <returns></returns>
		public DataTable GetTransfusionRequiremetsReport()
		{
			DataTable dtTR = null;
			
			// Check if the report is cumulative and adjust the dates
			if(this._isCumulativeReport == true)
			{
				this.StartDate = DateTime.MinValue;
				this.EndDate = DateTime.MinValue;
			}
			dtTR = DAL.PatientTransfusionRequirement.GetTransfusionRequiremetsForAllPatient(this.StartDate, this.EndDate);
			
			// Converting PatientGuid column of type Guid to PatientGuid column of type string - used to group records on report
			// grouping does not work on Guid type columns
			dtTR.Columns[TABLE.PatientTransfusionRequirement.PatientGuid].ColumnName = ARTIFICIAL.Guid;
			dtTR.Columns.Add(TABLE.PatientTransfusionRequirement.PatientGuid);
			dtTR.Columns.Add(ARTIFICIAL.PatientDisplayName);
			//
			int rowCount = dtTR.Rows.Count;
			DataRow [] invalidDataRows = new DataRow[rowCount];
			//
			for (int idx = 0; idx < rowCount; idx++)
			{
				dtTR.Rows[idx][TABLE.PatientTransfusionRequirement.PatientGuid] = dtTR.Rows[idx][ARTIFICIAL.Guid].ToString();
				dtTR.Rows[idx][ARTIFICIAL.PatientDisplayName] = BOL.Patient.BuildDisplayName(dtTR.Rows[idx][TABLE.Patient.PatientFirstName].ToString(),
				dtTR.Rows[idx][TABLE.Patient.PatientMiddleName].ToString(),
				dtTR.Rows[idx][TABLE.Patient.PatientLastName].ToString());
				BOL.AboRh aboRH = BOL.Patient.GetPatientAboRh((Guid)dtTR.Rows[idx][ARTIFICIAL.Guid]);
				dtTR.Rows[idx][ARTIFICIAL.ABORh] = aboRH.AboRHText;

				// If no TR info and no ABO/Rh info, save row to remove later; we only want patients 
				// that have a transfusion requirement, a special instruction or a valid ABO/Rh
				if( dtTR.Rows[idx].IsNull( dtTR.Columns[ARTIFICIAL.Category] ) 
					&& dtTR.Rows[idx].IsNull( dtTR.Columns[ARTIFICIAL.RequirementText] )
					&& dtTR.Rows[idx].IsNull( dtTR.Columns[ARTIFICIAL.DateEntered] )
					&& ( dtTR.Rows[idx].IsNull( dtTR.Columns[ARTIFICIAL.ABORh] ) || dtTR.Rows[idx][ARTIFICIAL.ABORh].ToString().Equals("NR") ) )
				{
					invalidDataRows[idx] = dtTR.Rows[idx];
				}
			}
			dtTR.Columns.Remove(ARTIFICIAL.Guid);
			dtTR.Columns.Remove(TABLE.Patient.PatientFirstName);
			dtTR.Columns.Remove(TABLE.Patient.PatientMiddleName);
			dtTR.Columns.Remove(TABLE.Patient.PatientLastName);
			//
			// Remove invalid rows
			for (int idx = 0; idx < rowCount; idx++)
			{
				if( invalidDataRows[idx] != null )
				{
					dtTR.Rows.Remove( invalidDataRows[idx] );
				}
			}
			//
			return dtTR;
		}

		#endregion

		///<Developers>
		///	<Developer></Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/15/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7889"> 
		///		<ExpectedInput>N/A</ExpectedInput>
		///		<ExpectedOutput>N/A</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7890"> 
		///		<ExpectedInput>N/A</ExpectedInput>
		///		<ExpectedOutput>N/A</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Generate and print report
		/// Used by VbecsConsoleReport application
		/// </summary>
        protected override VbecsReportPrinter createReportPrinter()
		{
            this._dtReportData = this.GetTransfusionRequiremetsReport();
            string reportCriteria = "Date Range: ";
            if (this.StartDate == DateTime.MinValue)
            {
                reportCriteria += "N/A (Cumulative Report)";
            }
            else
            {
                reportCriteria += Common.VBECSDateTime.FormatDateString(this.StartDate);
                reportCriteria += " - ";
                reportCriteria += Common.VBECSDateTime.FormatDateString(this.EndDate);
            }

            BOL.VbecsUser user = new BOL.VbecsUser(this.PrintedBy);
            DataSet dsHeader = BOL.VbecsReport.GetReportHeader(user.UserName);
            DataSet dsFooter = BOL.VbecsReport.GetReportFooter(reportCriteria);

            ReportDataSource reportSourceMain = new ReportDataSource();
            reportSourceMain.Name = "TransfusionRequirementsDataSet";
            reportSourceMain.Value = this._dtReportData;

            ReportDataSource reportSourceHeader = new ReportDataSource();
            if (dsHeader.Tables.Count > 0)
            {
                reportSourceHeader.Name = "ReportHeaderDataSet";
                reportSourceHeader.Value = dsHeader.Tables[0];
            }

            ReportDataSource reportSourceFooter = new ReportDataSource();
            if (dsFooter.Tables.Count > 0)
            {
                reportSourceFooter.Name = "ReportFooterDataSet";
                reportSourceFooter.Value = dsFooter.Tables[0];
            }

            Assembly assembly = Assembly.LoadFrom(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location) + "\\Reports.dll");
            Stream stream = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.TransfusionRequirements.TransfusionRequirementsReport.rdlc");

            LocalReport report = new LocalReport();
            report.DataSources.Add(reportSourceHeader);
            report.DataSources.Add(reportSourceFooter);
            report.DataSources.Add(reportSourceMain);
            report.LoadReportDefinition(stream);

            return new BOL.VbecsReportPrinter(this.PrinterName, false, report);
        }
	}
}
